float4x4 g_view_projection_matrix;	
float4x4 g_world_matrix;	
float4 g_camera_pos_vector;

texture g_cubeTex;

samplerCUBE CubeMapSampler = sampler_state
{
   Texture = <g_cubeTex>;
   MinFilter = Linear;
   MagFilter = Linear;
   AddressU  = Clamp;
   AddressV  = Clamp;
   AddressW  = Clamp;   
};

// -------------------------------------------------------------
// Output channels
// -------------------------------------------------------------
struct VS_OUTPUT
{
    	float4 Pos  : POSITION;
	float3 Reflect: TEXCOORD4;    
};

// -------------------------------------------------------------
// vertex shader function (input channels)
// -------------------------------------------------------------
VS_OUTPUT VS(float4 Pos : POSITION, float2 Tex : TEXCOORD, float3 Normal : NORMAL)
{
    VS_OUTPUT Out = (VS_OUTPUT)0;      
    Out.Pos = mul(Pos, g_world_matrix);	// transform Position
    Out.Pos = mul(Out.Pos, g_view_projection_matrix);	// transform Position
   float3 Norm = normalize(mul(Normal, g_world_matrix));
     
    // get a vector toward the camera/eye -> V
    float3 PosWorld  = normalize(mul(Pos, g_world_matrix));
    float3 Incident = normalize(PosWorld  - g_camera_pos_vector);
    
	// Reflection Vector for cube map: R = I - 2*N * (I.N)
	//Out.Reflect = reflect(Incident, Norm);
	Out.Reflect = Incident - 2 * Norm * dot(Incident, Norm);
	
   return Out;
}

// -------------------------------------------------------------
// Pixel Shader (input channels):output channel
// -------------------------------------------------------------
float4 PS( float3 Ref : TEXCOORD4) : COLOR
{
	return texCUBE(CubeMapSampler, Ref);    
}

// -------------------------------------------------------------

// Techniques
// -------------------------------------------------------------
technique normal
{
    pass P0
    {         
        Sampler[0] = (CubeMapSampler);		
    
        // compile shaders
        VertexShader = compile vs_3_0 VS();
        PixelShader  = compile ps_3_0 PS();
    }
}
